package com.androidbook.simplesearchintegration;

import android.app.Activity;
import android.app.SearchManager;
import android.content.ContentValues;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;

public class SimpleSearchIntegrationMenuActivity extends Activity {
    /** Metoda wywoływana podczas pierwszego tworzenia aktywności. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }

    public void onResetData(View view) {
        deleteAllFieldnotes();
        addFieldnote(
                "Zebra",
                "Byłem zaskoczony odgłosami wydawanymi przez zebry. Jestem przyzwyczajony do cichych koni, natomiast zebry wydają odgłosy podobne od osłów.\nPatrz więcej: http://j.mp/afz0Yn");
            addFieldnote(
                "Pawian",
                "Pawiany można znaleźć w zaskakująco różnych środowiskach i wykazują one wyjątkowo duże zdoności adaptacji. W zasadzie potrzebują jedynie źródła wody oraz bezpiecznego miejsca do spania, takiego jak wysokie drzewo lub półka skalna. \nPatrz więcej: http://j.mp/cZycRs");
            addFieldnote(
                "Lampart",
                "Lamparty są najbardziej nieuchwytnym gatunkiem Wielkiej Piątku - najbardziej niebezpiecznych myśliwych zamieszkujących Afrykę. Należą do niej: lwy, słonie, bawoły, lamparty i nosorożce. \nPatrz więcej: http://j.mp/ap221U");
            addFieldnote(
                "Gnu",
                "Zarówno samce, jak i samice antylop gnu mają zakrzywione rogi. Często można zobaczyć je pasące się w towarzystwie zebr. \nCzytaj więcej: http://j.mp/bpKwff");
            addFieldnote(
                "Bawół afrykański",
                "Zarówno samce, jak i samice bowałów afrykańskich mają ciężkie, ostre rogi. Te rogi są śmiertelnie niebezpieczną bronią, używaną w walce z drapieżnikami oraz o miejsce w stadzie; samce używają ich także w walce o dominację. \nPatrz więcej: http://j.mp/9qlBTe");
            addFieldnote(
                "Hiena centkowana",
                "Hieny mają najdziwniejsze szczęki spośród wszystkich zwierząt. Dzięki tym szczękom, potężnym zębon oraz ogromnemu apetytowi, hieny centowane mogą zutylizować niemal całe szczątki, za wyjątkiem zębów i rogów. To czego nie są w stanie strawić, zwracają. Nawet wysuszone szczątki zwierzęce zawierają proteiny i minerały, dlatego są cennym pożywieniem w okresie suszy. Ponieważ hieny jedzą kości, dlatego ich odchody są białe.\nPatrz więcej: http://j.mp/ajm2aY");
            addFieldnote(
                "Dujker",
                "Dujkery to niewielkie antylopy zamieszkujące lasy i obszary gęstego buszu\nPatrz więcej: http://j.mp/bkK1w6");
            addFieldnote(
                "Impala",
                "Jednym z pierwszych zwierząt jakie zapewne napotkasz w grze, są stada antylop impala. Moja przyjaciółka Monika nazywa je szczurami pustyni, jest to bowiem najpopularniejszy gatunek afrykańskich antylop jakie można zobaczyć.\nPatrz więcej: http://j.mp/9Jslga");
            addFieldnote(
                "Kob",
                "Najprościej je zidentyfikować patrząc na nie od tyłu - mają na zadzie duży biały pierścień.\nPatrz więcej: http://j.mp/dq7v44");
    }

    private void deleteAllFieldnotes() {
        getContentResolver().delete(SimpleFieldnotesContentProvider.CONTENT_URI,
            null, null);
    }

    private void addFieldnote(String headline, String story) {
        ContentValues values = new ContentValues();
        values.put(SimpleFieldnotesContentProvider.FIELDNOTES_TITLE, headline);
        values.put(SimpleFieldnotesContentProvider.FIELDNOTES_BODY, story);
        getContentResolver().insert(SimpleFieldnotesContentProvider.CONTENT_URI,
            values);
    }

    public void onForceSearch(View view) {
        onSearchRequested();
    }

    public void onLaunchGlobalSearchSettings(View view) {
        Intent intent = new Intent(SearchManager.INTENT_ACTION_SEARCH_SETTINGS);
        startActivity(intent);
    }
}